﻿// JScript File

/*  Tabs.js ***********************************************************
*
*   -   Applies a Transitions effect to all elements using .TabOff class
*       from Style.css -- The Transition effect should be defined in the
*       style sheet, this script just applies it
*
*   -   Call OnTabDoTransition() to apply the effect
*           - Usually applied from the body's onload event
*
*   -   Pre-conditions: each .TabOff element must be a <a> and have an id
*       <a id="idMyTab" href="MyTab.html" class="TabOff">My Tab</a>
*
***********************************************************************/

/*  Globals / Defines   ***********************************************
*
*   g_iTabsTransitionApplyDelay =   Number of milliseconds to wait after
*                                   OnTabDoTransition() is called before
*                                   making the tabs visible -- 
*                                   Shouldn't be more than 1/2 - 1 second
*
*   g_iTabsDelayBetweenTabs     =   Number of milliseconds to wait between
*                                   displaying tabs
*
*   g_sTabsFontColorFadingIn    =   Font color to use while the tabs are
*                                   in transitions
***********************************************************************/
var g_iTabsTransitionApplyDelay = 500;
var g_iTabsDelayBetweenTabs     = 1000;
var g_sTabsFontColorFadingIn    = "blue";
var g_sTabsBackColorFadingIn    = "white"

//non-configurable globals
var g_sTabsFontColor            = "";
var g_sTabsBackColor            = "";
var g_iTabsTimeoutID            = "0";
var g_iTabsLastElementId        = "";



/*  function TabApplyTransition()   ***********************************
*
*   -   Loops through each element
*   -   Sets invisible ones to visible and plays the transitions effect
***********************************************************************/
function TabApplyTransition()
{
    var bFoundOne = false;
    var Item = 0;
    var pEl = null;
    
    g_iTabsTimeoutID = 0;
    
    if ("" != g_iTabsLastElementId)
    {
        //remove bold from text
        pEl = document.getElementById(g_iTabsLastElementId);
        if (null != pEl)
        {
            pEl.style.fontWeight = "";
            pEl.style.backgroundColor = g_sTabsBackColor;
            pEl.style.color = g_sTabsFontColor;
        }
        
        g_iTabsLastElementId = "";
        
    } //if ("" != g_iTabsLastElementId)
        
    
    var pElements = document.anchors;
    if (null == pElements)
    {
        return;     //no <a> tags
    }

    //loop through all "hidden" tabs, call TabDisplayIt() for each one
    for (Item in pElements)
    {
        if ("TabOff" == pElements[Item].className)
        {
            pEl = document.getElementById(pElements[Item].id);
            if (null != pEl)
            {
                if ("hidden" == pEl.style.visibility)
                {
                    //found a hidden TabOff anchor element
                    //display it, then jump out of this loop
                    g_iTabsLastElementId = pElements[Item].id;
                    pEl.filters[0].apply();
                    pEl.style.visibility = "visible";
                    g_sTabsBackColor = pEl.style.backgroundColor;
                    pEl.style.backgroundColor = g_sTabsBackColorFadingIn;
                    g_sTabsFontColor = pEl.style.color;
                    pEl.style.color = g_sTabsFontColorFadingIn;
                    pEl.style.fontWeight = "bold";
                    pEl.filters[0].play();
                    bFoundOne = true;
                    break;
                }
            }
            
        } //if "TabOff" is className
    } //loop pElements
    
    if (bFoundOne)
    {
        //call function again to see if there are any more
        g_iTabsTimeoutID = window.setTimeout(TabApplyTransition, g_iTabsDelayBetweenTabs);
    }

} //function TabApplyTransition()



/*  function OnTabDoTransition()   ************************************
*
*   -   Loops through each element
*   -   Sets them to invisible, then calls TabApplyTransition() on a
*       timer -- TabApplyTransition() makes each element visible again
***********************************************************************/
function OnTabDoTransition()
{
    var pElements = document.anchors;
    if (null == pElements)
    {
        return;     //no <a> tags
    }

    //hide all tabs
    var bFoundSome = false;
    var Item = 0;
    var pEl = null;
    for (Item in pElements)
    {
        if ("TabOff" == pElements[Item].className)
        {
            pEl = document.getElementById(pElements[Item].id);
            if (null != pEl)
            {
                if (0 == pEl.filters.Length)
                {
                    return;     //no filter is defined for TabOff class
                                //nothing to do
                }
                
                pEl.style.visibility = "hidden";
                bFoundSome = true;
            }
            
        } //if "TabOff" is className
    }//loop pElements
    
    if (true == bFoundSome)
    {
        //now turn them back on using the transitions effect
        g_iTabsTimeoutID = window.setTimeout(TabApplyTransition, g_iTabsTransitionApplyDelay);
    }

} //function OnTabDoTransition()


/*  function OnTabPanelEffect() ***************************************
*
*   -   idTabPanel is set to 'hidden' in Style.css
*   -   This function sets it to 'visible' and applys the appropriate
*       filter effect (if specified)
*   -   Call <body onload="OnTabPanelEffect()">
***********************************************************************/
function OnTabPanelEffect()
{
    var pTabPanel = document.getElementById("idTabPanel");
    if (null == pTabPanel)
    {
        return;     //no element id="idTabPanel"
    }
    
    if (idTabPanel.filters.length > 0)
    {
        //apply filter effect if it exits
        pTabPanel.filters.item(0).enabled = true;
        pTabPanel.filters.item(0).apply()
    }
    
    pTabPanel.style.visibility = "visible";
    
    if (pTabPanel.filters.length > 0)
    {
        pTabPanel.filters.item(0).play()
    }
        
} //function OnTabPanelEffect()